#!/bin/bash

REPO_DIR="/GITordner/"

echo " $(date)"
echo " Scanning repositories in: $REPO_DIR"
echo "--------------------------------------"

IFS=$'\n'
for dir in "$REPO_DIR"/*; do
	echo "$dir"
    if [ -d "$dir/.git" ]; then
        echo " Repository: $(basename "$dir")"
        #(
			cd "$dir" || continue

			git fetch --all --quiet

			LOCAL=$(git rev-parse @)
			REMOTE=$(git rev-parse @{u} 2>/dev/null)
			BASE=$(git merge-base @ @{u} 2>/dev/null)

			if [ "$LOCAL" = "$REMOTE" ]; then
				echo " Up to date"
			elif [ "$LOCAL" = "$BASE" ]; then
				echo "  Update available (remote ahead)"
			elif [ "$REMOTE" = "$BASE" ]; then
				echo "  Local changes ahead (you pushed but not pulled)"
			else
				echo "  Diverged"
			fi
		#)
        echo "--------------------------------------"
    fi
done
